/*____________________________________________________________________________
	Copyright (C) 1997 Network Associates Inc. and affiliated companies.
	All rights reserved.
	
	
	
	$Id: CInternetUtilities.cp,v 1.3 1999/11/12 12:04:46 jason Exp $
____________________________________________________________________________*/

#include <string.h>

#include "pgpMem.h"

#include "CInternetUtilities.h"



struct MyInetHostInfo {
	InetHostInfo	hInfo;
	UInt8			done;
	OTResult		result;
};

struct MyInetDomainName {
	InetDomainName	domainName;
	UInt8			done;
	OTResult		result;
};


CInternetUtilities::CInternetUtilities()
	: mInetSvcRef(0)
{
	OSStatus	err;

	mInetSvcRef = ::OTOpenInternetServices(	kDefaultInternetServicesPath,
											0,
											&err);
	if (err != kOTNoError) {
		ThrowPGPError_(err);
	}
	err = ::OTInstallNotifier(	mInetSvcRef,
								NotifyProc,
								this);
	if (err != kOTNoError) {
		ThrowPGPError_(err);
	}
	err = ::OTSetAsynchronous(mInetSvcRef);
	if (err != kOTNoError) {
		ThrowPGPError_(err);
	}
}



CInternetUtilities::~CInternetUtilities()
{
	if (mInetSvcRef != 0) {
		::OTSetSynchronous(mInetSvcRef);
		::OTCloseProvider(mInetSvcRef);
	}
}


	PGPHostEntry *
CInternetUtilities::GetHostByName(
	const char * inName)
{
	SSocketsThreadContext *	theContext = CSocket::GetThreadContext();
	MyInetHostInfo *		hInfo = static_cast<MyInetHostInfo *>(::OTAllocMem(sizeof(MyInetHostInfo)));
	PGPHostEntry *			result = 0;
	OSStatus				err;
	
	if (hInfo == 0) {
		ThrowPGPError_(kPGPError_OutOfMemory);
	}
	try {
		// Get the info
		hInfo->done = 0;
		err = ::OTInetStringToAddress(	mInetSvcRef,
										(char *) inName,
										&hInfo->hInfo);
		if (err != kOTNoError) {
			ThrowPGPError_(err);
		}
		while (! hInfo->done) {
			if (CSocket::CallIdleEventHandler() != kPGPError_NoErr) {
				if (! ::OTCompareAndSwap8(0, 1, &hInfo->done)) {
					::OTFreeMem(hInfo);
				}
				hInfo = 0;
				ThrowPGPError_(kPGPError_UserAbort);
			}
	 	}
		if (hInfo->result != kOTNoError) {
			ThrowPGPError_(hInfo->result);
		}
											
		// Insert the name
		strncpy(theContext->hostEntry.h_name, hInfo->hInfo.name, kMaxHostNameLen);
		theContext->hostEntry.h_name[kMaxHostNameLen] = 0;
		::BlockMoveData(	hInfo->hInfo.addrs,
							theContext->hAddressesBuffer,
							sizeof(theContext->hAddressesBuffer));
		pgpClearMemory(	theContext->hAddressesListBuffer,
						sizeof(theContext->hAddressesListBuffer));
		for (UInt8 i = 0; (i < kMaxHostAddrs)
		  && (theContext->hAddressesBuffer[i] != 0); i++) {
			theContext->hAddressesListBuffer[i] = &theContext->hAddressesBuffer[i];
		}
		result = &theContext->hostEntry;
		::OTFreeMem(hInfo);
	}
	
	catch (...) {
		if (hInfo != 0) {
			::OTFreeMem(hInfo);
		}
	}

	return result;
}



	PGPHostEntry *
CInternetUtilities::GetHostByAddress(
	PGPInternetAddress	inAddress)
{
	SSocketsThreadContext *	theContext = CSocket::GetThreadContext();
	MyInetDomainName *		domainName = static_cast<MyInetDomainName *>(
											::OTAllocMem(sizeof(MyInetDomainName)));
	PGPHostEntry *			result = 0;
	OSStatus				err;

	if (domainName == 0) {
		ThrowPGPError_(kPGPError_OutOfMemory);
	}
	try {
		// Get the info
		domainName->done = 0;
		err = ::OTInetAddressToName(	mInetSvcRef,
										inAddress.s_addr,
										domainName->domainName);
		if (err != kOTNoError) {
			ThrowPGPError_(err);
		}
		while (! domainName->done) {
			if (CSocket::CallIdleEventHandler() != kPGPError_NoErr) {
				if (! ::OTCompareAndSwap8(0, 1, &domainName->done)) {
					::OTFreeMem(domainName);
				}
				domainName = 0;
				ThrowPGPError_(kPGPError_UserAbort);
			}
	 	}
		if (domainName->result != kOTNoError) {
			ThrowPGPError_(domainName->result);
		}
		result = GetHostByName(domainName->domainName);
		::OTFreeMem(domainName);
	}
	
	catch (...) {
		if (domainName != 0) {
			::OTFreeMem(domainName);
		}
		throw;
	}
										
	return result;
}



	void
CInternetUtilities::GetHostName(
	char *	outName,
	SInt32	inNameLength)
{
	InetInterfaceInfo	info;
	PGPHostEntry *		result;
	OSStatus			err;
	
	err = ::OTInetGetInterfaceInfo(&info, kDefaultInetInterface);
	if (err != kOTNoError) {
		ThrowPGPError_(err);
	}
	
	result = GetHostByAddress(*((PGPInternetAddress *) &info.fAddress));
	strncpy(outName, result->h_name, inNameLength - 1);
	outName[inNameLength - 1] = 0;
}



	pascal void
CInternetUtilities::NotifyProc(
	void *		contextPtr,
	OTEventCode	code, 
	OTResult	result,
	void *		cookie)
{
	(void) contextPtr;
	
	switch (code) {
		case T_DNRSTRINGTOADDRCOMPLETE:
		{
			MyInetHostInfo *	hInfo = static_cast<MyInetHostInfo *>(cookie);
			
			if (::OTCompareAndSwap8(0, 1, &hInfo->done)) {
				hInfo->result = result;
			} else {
				::OTFreeMem(hInfo);
			}
		}
		break;
		
		
		case T_DNRADDRTONAMECOMPLETE:
		{
			MyInetDomainName *	domainName = static_cast<MyInetDomainName *>(cookie);
			
			if (::OTCompareAndSwap8(0, 1, &domainName->done)) {
				domainName->result = result;
			} else {
				::OTFreeMem(domainName);
			}
		}
		break;
	}
}
